﻿// Procedure Loader Hide
#pragma TextEncoding = "UTF-8"
#pragma rtGlobals=3		// Use modern global access method and strict wave access.
#pragma hide=1

// uncomment to debug
//#define DEBUG

// ***
// FUNCTIONS

Function imgT_UserLoader(string funcname)

	variable vrtn
	FUNCREF imgTBaseLoader f = $funcname
	imgTLoad_Init()
	vrtn = f()
	imgTLoad_Close()
	return vrtn
end

Function imgTBaseLoader()
	return 0
end

Static Function imgTLoad_Init()

	SetDataFolder root:
	KillDataFolder/Z imgTLoad_TMP
	NewDataFolder/O/S imgTLoad_TMP
	
	return 0
end

Static Function imgTLoad_Close()

	string folderstr

	SetDataFolder root:	
	PathInfo uIPath
	if (v_flag == 0)
		return -1
	endif
	folderstr = CleanUpName(ParseFilePath(0,S_path,":",1,0),0)
	ReNameDataFolder imgTLoad_TMP $folderstr
	T0_ConvertDataFolders(dFolder = folderstr)	

	return 0
end

Function/S f_LoaderOptions()

	string rstr, fList
	rstr = "One or Multiple Files;Entire Folder;Image Stack;Internal Data Folder;"
	
	fList = FunctionList("imgTLoader_*",";","KIND:2")
	if (strlen(fList) != 0)
		fList = "\\M1-;" + ReplaceString("imgTLoader_",fList,"")
		rstr += fList
	endif
	return rstr
end

// draw tab0 - load
Function disp_Tab0Draw(pwidth,pheight,ptabpos)
	variable pwidth, pheight, ptabpos

	variable tvoffset = ptabpos+30
	
	TabControl tab_main, value=0, userdata(ptab)="0"
	
	TitleBox load_tab0,pos={12,tvoffset},size={84,22},title="Load Image(s)"
	TitleBox load_tab0,fSize=16,frame=0,fStyle=1,disable=0

	CheckBox checkgraw_tab0,pos={12+140,tvoffset+4},size={100,16},title="Single Channel", proc=X_CheckProc
	CheckBox checkgraw_tab0,value=1, help={"The images to be loaded are single channel images.\rUncheck to have options for multi-channel images."}

	tvoffset += 25
	
	PopupMenu popupload_tab0,pos={22,tvoffset},size={113,25},title="What"
	PopupMenu popupload_tab0,mode=1,popvalue="One or Multiple Files",value=f_LoaderOptions()
	PopupMenu popupload_tab0,disable=0,proc=X_PopMenuProc
	PopupMenu popupload_tab0,help={"Choose the type of load method."}
	
	CheckBox checkasstack_tab0, pos={pwidth-170,tvoffset-2}, title="as stack",proc=X_CheckProc
	CheckBox checkasstack_tab0, value=0, help={"Load N>4 files as stack or load a stack as a stack"}
	
	CheckBox checkasfolder_tab0, pos={pwidth-100,tvoffset-2}, title="one folder",proc=X_CheckProc
	CheckBox checkasfolder_tab0, value=0, help={"Load multiple files or stack as multiple files into one folder"}

	tvoffset += 25
	
	SetVariable startimg_tab0, pos={25,tvoffset},size={120,16},title="Start At"
	SetVariable startimg_tab0, value=_NUM:1, limits={0,inf,1}, disable=1
	SetVariable startimg_tab0, help={"What is the first stack image to load (zero is first)?"}
	SetVariable endimg_tab0, pos={25+130,tvoffset},size={120,16},title="Load Only"
	SetVariable endimg_tab0, value=_NUM:inf, limits={1,inf,1}, disable=1
	SetVariable endimg_tab0, help={"What is the last stack image to load? INF loads to end."}
	SetVariable stepimg_tab0, pos={25+260,tvoffset},size={120,16},title="Step By"
	SetVariable stepimg_tab0, value=_NUM:1, limits={1,inf,1}, disable=1
	SetVariable stepimg_tab0, help={"How to step through stacks?"}
	
	tvoffset += 20
	
	SetVariable startind_tab0, pos={25,tvoffset},size={120,16},title="Start Label"
	SetVariable startind_tab0, value=_NUM:0, limits={0,inf,1}, disable=1, help={"Images are loaded with a suffix.\rStart at what number?"}
	SetVariable stepind_tab0, pos={25+130,tvoffset},size={120,16},title="Step Label"
	SetVariable stepind_tab0, value=_NUM:1, limits={1,inf,1}, disable=1, help={"What step for image name suffix?"}
	
	tvoffset +=25
	
	CheckBox checkgred_tab0,pos={30,tvoffset},size={102,16},title="extract red channel", disable=2
	CheckBox checkgred_tab0,value=0, proc=X_CheckProc, help={"Extract red channel?"}
	CheckBox checkggreen_tab0,pos={30,tvoffset+15},size={114,16},title="extract green channel", disable=2
	CheckBox checkggreen_tab0,value=0, proc=X_CheckProc, help={"Extract green channel?"}
	CheckBox checkgblue_tab0,pos={30,tvoffset+30},size={107,16},title="extract blue channel", disable=2
	CheckBox checkgblue_tab0,value=0, proc=X_CheckProc, help={"Extract blue channel?"}
	CheckBox checkgGray_tab0,pos={30,tvoffset+45},size={109,16},title="generate grayscale", disable=2
	CheckBox checkgGray_tab0,value=0, proc=X_CheckProc, help={"Generate grayscale from all three RGB channels?"}
	
	CheckBox checkgsource_tab0,pos={180,tvoffset},size={76,16},title="store source"
	CheckBox checkgsource_tab0,value=0, help={"Store (retain) the source image after loading it into the experiment?"}
	
	CheckBox checkallow16bit_tab0,pos={180,tvoffset+15},size={76,16},title="allow 16+ bit"
	CheckBox checkallow16bit_tab0,value=0, help={"Allow 16+ bit images? Default is to force all files to 8 bit only."}
	
	ValDisplay valdispNimgs_tab0 title="Sets\rLoaded",pos={300,tvoffset+2},size={80,20}
	ValDisplay valdispNimgs_tab0 value=f_NImagesLoaded(), fSize=10

	tvoffset += 35
	
	Button buttonLoad_tab0,pos={300,tvoffset},size={80,25},proc=X_ButtonProc,title="Load"

	return 0
end

// update tab 0
Function disp_UpdateTab0()
	
	STRUCT S_LoadSettings ls
	Sf_GetLoadSettings(ls)
	
	variable conv = 0
	// not a stack
	SetVariable/Z startimg_tab0, win=$k_fullpanel, disable=1
	SetVariable/Z stepimg_tab0, win=$k_fullpanel, disable=1
	SetVariable/Z endimg_tab0, win=$k_fullpanel, disable=1
	SetVariable/Z startind_tab0, win=$k_fullpanel, disable=1
	SetVariable/Z stepind_tab0, win=$k_fullpanel, disable=1
	// all other options open
	Checkbox checkgraw_tab0, win=$k_fullpanel, disable=0
	Checkbox checkgsource_tab0, win=$k_fullpanel, disable=0
	if (ls.asstack)
		Checkbox checkgsource_tab0, win=$k_fullpanel, value=0, disable=2
	endif
	Checkbox checkallow16bit_tab0, win=$k_fullpanel, disable=0
	Checkbox checkgred_tab0, win=$k_fullpanel, disable=0
	Checkbox checkggreen_tab0, win=$k_fullpanel, disable=0
	Checkbox checkgblue_tab0, win=$k_fullpanel, disable=0
	Checkbox checkggray_tab0, win=$k_fullpanel, disable=0
	CheckBox checkasstack_tab0, win=$k_fullpanel, disable=(2*ls.asfolder)
	CheckBox checkasfolder_tab0, win=$k_fullpanel, disable=(2*ls.asstack)
	ValDisplay valdispNimgs_tab0, win=$k_fullpanel, value=f_NImagesLoaded()
	
	// what is to be loaded
	switch(ls.what)
		case 1:
		case 2:
			break
		case 3:	// load stack
			SetVariable/Z startimg_tab0, win=$k_fullpanel, disable=0
			SetVariable/Z stepimg_tab0, win=$k_fullpanel, disable=0
			SetVariable/Z endimg_tab0, win=$k_fullpanel, disable=0
			SetVariable/Z startind_tab0, win=$k_fullpanel, disable=(2*ls.asstack)
			SetVariable/Z stepind_tab0, win=$k_fullpanel, disable=(2*ls.asstack)
			break
		case 4:	// convert
			Checkbox checkgraw_tab0, win=$k_fullpanel, disable=1
			Checkbox checkgsource_tab0, win=$k_fullpanel, disable=1
			Checkbox checkallow16bit_tab0, win=$k_fullpanel, disable=1
			Checkbox checkgred_tab0, win=$k_fullpanel, disable=1
			Checkbox checkggreen_tab0, win=$k_fullpanel, disable=1
			Checkbox checkgblue_tab0, win=$k_fullpanel, disable=1
			Checkbox checkggray_tab0, win=$k_fullpanel, disable=1
			CheckBox checkasstack_tab0, win=$k_fullpanel, disable=1
			CheckBox checkasfolder_tab0, win=$k_fullpanel, disable=1
			conv = 1
			break
		default:	// other loaders
			Checkbox checkgraw_tab0, win=$k_fullpanel, disable=1
			Checkbox checkgsource_tab0, win=$k_fullpanel, disable=1
			Checkbox checkallow16bit_tab0, win=$k_fullpanel, disable=1
			Checkbox checkgred_tab0, win=$k_fullpanel, disable=1
			Checkbox checkggreen_tab0, win=$k_fullpanel, disable=1
			Checkbox checkgblue_tab0, win=$k_fullpanel, disable=1
			Checkbox checkggray_tab0, win=$k_fullpanel, disable=1
			CheckBox checkasstack_tab0, win=$k_fullpanel, disable=1
			CheckBox checkasfolder_tab0, win=$k_fullpanel, disable=1
			conv = 2
			break
	endswitch
	
	switch(conv)
		case 0:
			if (ls.graw)
				Checkbox checkgred_tab0, win=$k_fullpanel, disable=2, value=0
				Checkbox checkggreen_tab0, win=$k_fullpanel, disable=2, value=0
				Checkbox checkgblue_tab0, win=$k_fullpanel, disable=2, value=0
				Checkbox checkggray_tab0, win=$k_fullpanel, disable=2, value=0
			else
				Checkbox checkgred_tab0, win=$k_fullpanel, disable=0 //, value=ls.red
				Checkbox checkggreen_tab0, win=$k_fullpanel, disable=0 //, value=ls.green
				Checkbox checkgblue_tab0, win=$k_fullpanel, disable=0 //, value=ls.blue
				Checkbox checkggray_tab0, win=$k_fullpanel, disable=0 //, value=ls.gray
			endif
			
			if (ls.howmany == 0)
				Button buttonLoad_tab0, win=$k_fullpanel, title="Load", userData="Load", disable=2
			else
				Button buttonLoad_tab0, win=$k_fullpanel, title="Load", userData="Load", disable=0
			endif
			break
		case 1:
			Button buttonLoad_tab0, win=$k_fullpanel, title="Convert", userData="Convert", disable=0
			break
		case 2:
			Button buttonLoad_tab0, win=$k_fullpanel, title="Load", userData="Load", disable=0
			break
	endswitch
	
	return 0
end

// clean up TIFF tags
Static Function cleanup_Tags([string fldrname])
	
	string fList, theTagFldr, newfldr
	variable ic,nitems
	
	if (ParamIsDefault(fldrname))
		fList = DataFolderDir(1)
		fList = ReplaceString("FOLDERS:",fList,"")
		nitems = ItemsInList(fList,",")
		for(ic=0;ic<nitems;ic+=1)
			theTagFldr = StringFromList(ic,fList,",")
			if (stringmatch(theTagFldr,"Tag*") == 1)
				NewDataFolder/O imgT_tags
				MoveDataFolder/O=1 $theTagFldr imgT_tags
			endif
		endfor
	else
		DFREF cdf = GetDataFolderDFR()
		SetDataFolder ::
		fList = DataFolderDir(1)
		fList = ReplaceString("FOLDERS:",fList,"")
		nitems = ItemsInList(fList,",")
		newfldr = ":" + fldrname + ":imgT_tags"
		NewDataFolder/O $newfldr
		for(ic=0;ic<nitems;ic+=1)
			theTagFldr = StringFromList(ic,fList,",")
			if (stringmatch(theTagFldr,"Tag*") == 1)
				MoveDataFolder/O=1 $theTagFldr $newfldr
			endif
		endfor
	endif
	return 0
end

// load a set of images
// how 0 - one or multiple, 1 - entire folder
Function T0_LoadImages(variable how)
	
	// get load settings
	STRUCT S_LoadSettings ls
	Sf_GetLoadSettings(ls)

	if (ls.howmany == 0)
		DoAlert/T="Load Error" 0, "You must set processing options to load!"
		return -1
	endif

	string fFilter = "Image Files:.png,.jpg,.jpeg,.tif,.tiff;"
	string fList, theFile, fPath, FolderNameList = ""
	string asstr = "", theDFName, fFullName, pstr
	variable vRefNum, nt, ic
	
	// get file list
	switch(how)
		case 0:		// one or multiple files
			Open/MULT=1/D/R/F=fFilter/M="Select image(s) to load" vRefNum
			if (strlen(S_filename)==0)
				Close/A
				ls.loaderror = -1
				return -1
			endif
			fList = ReplaceString("\r",S_filename,";")
			theFile = StringFromList(0,fList)
			fPath = ParseFilePath(1,theFile,":",1,0)
			NewPath/O/Q/Z imgPath, fPath
			break
		case 1:		// from folder
			NewPath/O/Q/M="Select a folder with the images"/Z imgPath
			if (v_flag != 0)
				ls.loaderror = -1
				return -1
			endif
	endswitch	
	flist = SortList(flist)
	PathInfo imgPath
	fPath = S_path

	// validate stack loading
	if (ls.asstack)
		ls.asstack = f_IsValidateforStack(fList, 1)
		if (ls.asstack)
			ls.source = 0
		endif
	endif
	
	// load images
	nt = ItemsInList(fList)
	if (ls.asstack == 1)
		switch(how)
			case 0:
			case 1:
				theDFName = cleanupname(ParseFilePath(0,fPath,":",1,0),0)
				break
		endswitch
		theDFName = create_ImgTDF(theDFName, ls)
		for (ic=0;ic<nt;ic+=1)
			theFile = StringFromList(ic,fList)
			theFile = ParseFilePath(0,theFile,":",1,0)
			FolderNameList += loadinto_imgTDF(theDFName, theFile, ls, ic)
		endfor
		asstr = "\r(all images as stack)"
	else
		if (ls.asfolder == 1)
			// loop through to load each file into one folder
			theFile = ParseFilePath(0,fPath,":",1,0)
			theDFName = CleanupName(theFile,0)
			theDFName = create_ImgTDF(theDFName, ls)
			for (ic=0;ic<nt;ic+=1)
				theFile = StringFromList(ic,fList)
				theFile = ParseFilePath(0,theFile,":",1,0)
				FolderNameList += loadinto_imgTDF(theDFName, theFile, ls, 0)
			endfor
			asstr = "\r(all images in one folder)"
		else
			// loop through to load each file
			for (ic=0;ic<nt;ic+=1)
				theFile = StringFromList(ic,fList)
				theFile = ParseFilePath(0,theFile,":",1,0)
				theDFName = cleanup_ImageFileName(theFile)
				theDFName = create_ImgTDF(theDFName, ls)
				FolderNameList += loadinto_imgTDF(theDFName, theFile, ls, 0)
			endfor
			asstr = "\r(each image in its own folder)"
		endif
	endif
	
	if (nt > 1)
		pstr = f_DateTimeStamp() + "\r -> Loaded multiple image files from folder " + fPath
	else
		pstr = f_DateTimeStamp() + "\r -> Loaded one image files from folder " + fPath
	endif
	pstr += FolderNameList + asstr
	print pstr
	
	return 0
end

// load a stack of TIFF images
Function T0_LoadStackTIFFImgs()
	
	// get load settings
	STRUCT S_LoadSettings ls
	Sf_GetLoadSettings(ls)

	if (ls.howmany == 0)
		DoAlert/T="Load Error" 0, "You must set something to load!"
		return -1
	endif
	
	SetDataFolder root:
	
	string fFilter = "TIF/TIFF Images ONLY:.tif,.tiff;"	
	string fList, theFile, theBaseFileName, fPath, FolderNameList = ""
	string asstr = "", theDFName, fFullName, pstr
	string fSlicePrefix, fSliceName
	variable loaded, vRefNum, nt, ic, no, nf, ns, nmax, dn

	// select files
	Open/MULT=0/D/R/F=fFilter/M="Select a TIF/TIFF image stack" vRefNum
	if (strlen(S_filename)==0)
		Close/A
		ls.loaderror = -1
		return -1
	endif
	theFile = S_filename

	// get path and file names	
	fPath = ParseFilePath(1,theFile,":",1,0)
	fFullName = ParseFilePath(0,theFile,":",1,0)
	fSlicePrefix = ParseFilePath(3,theFile,":",0,0)
	NewPath/O/Q/Z imgPath, fPath
	
	// get number of images in stack
	KillDataFolder/Z imgTtmp
	NewDataFolder/O/S imgTtmp	
	ImageLoad/Q/C=0/T=TIFF/RTIO/P=imgPath/Z theFile
	loaded = v_flag
	SetDataFolder root:
	KillDataFolder/Z imgTtmp
	if (loaded == 0)
		ls.loaderror = -1
		return -1
	endif
	
	nmax = V_numImages

	if (ls.asstack)
		// get each file and append to stack
		theFile = ParseFilePath(0,theFile,":",1,0)
		theBaseFileName = cleanup_ImageFileName(theFile)
		theDFName = create_ImgTDF(theBaseFileName, ls)
		FolderNameList = load_StackasStack(theDFName, theFile, ls, stnum=no, digits=dn)	
	else	
		// set the loop parameters
		no = ls.startimage - 1
		ns = ls.stepimage
		
		if (numtype(ls.endimage)!=0)
			nf = nmax
		else
			nf = ns*ls.endimage
			if (nf > nmax)
				nf = nmax
			endif
		endif
	
		// set the digits for sequencing image names
		dn = ls.startindex + nf*ls.stepindex
		dn = round(log(dn))
		
		theFile = ParseFilePath(0,theFile,":",1,0)
		theBaseFileName = cleanup_ImageFileName(theFile)
		// loop through to load images from stack as individual images
		for (ic=no;ic<nf;ic+=ns)
			theDFName = create_ImgTDF(theBaseFileName, ls, stnum=(no+(ic/ns)), digits=dn)
			FolderNameList += loadinto_imgTDF(theDFName, theFile, ls, 0, stindx=ic) + " at index " + num2str(ic) + " for suffix _" + num2str(ic/ns)
		endfor
		asstr = "\r(each layer in its own folder)"
	endif
	
	pstr = f_DateTimeStamp() + " -> Loaded a TIF/TIFF image stack from folder " + fPath
	pstr += FolderNameList + asstr
	print pstr
	
	return 0
end

// process the loaded image (img_source)
Static Function process_ImgSource(fname, ls)
	string fname
	STRUCT S_LoadSettings &ls

	wave/Z img_source
	wave/Z img_red, img_green, img_blue, img_gray
	
	variable bd, nlayer
	string nname = ""
	
	// convert to 8 bit if needed
	bd = f_ImageBitDepth(simgname = "img_source")
	if ((bd > 8) && !ls.allow16bit)
		Redimension/D img_source
		img_source /= 2^8
		Redimension/B/U img_source
	endif
	
	// assure that image dimensions are honored
	bd = DimSize(img_source,2)
	if (bd == 0)
		ls.red = 0
		ls.green = 0
		ls.blue = 0
		ls.gray = 0
		ls.graw = 1
	endif
	
	if (ls.asfolder == 1)
		nname = "_" + cleanup_ImageFileName(fname) //CleanUpName(StringFromList(0,fname,"."),0)
	endif
	
	// generate red
	if (ls.red)
		ImageTransform/P=0 getPlane img_source
		wave M_ImagePlane
		if (!ls.asstack)
			rename M_ImagePlane img_red
			wave img_red
		else
			if (!WaveExists(img_red))
				rename M_ImagePlane img_red
				wave img_red
				redimension/N=(-1,-1,1) img_red
			else
				nlayer = DimSize(img_red,2)
				ImageTransform/INSW=M_ImagePlane/P=(nlayer)/O insertZplane img_red
				killwaves/Z M_ImagePlane
			endif
		endif
		if (ls.asfolder)
			nname = "img_red" + nname
			rename img_red $nname
		endif
	endif
	
	// generate green
	if (ls.green)
		ImageTransform/P=1 getPlane img_source
		wave M_ImagePlane
		if (!ls.asstack)
			rename M_ImagePlane img_green
			wave img_green
		else
			if (!WaveExists(img_green))
				rename M_ImagePlane img_green
				wave img_green
				redimension/N=(-1,-1,1) img_green
			else
				nlayer = DimSize(img_green,2)
				ImageTransform/INSW=M_ImagePlane/P=(nlayer)/O insertZplane img_green
				killwaves/Z M_ImagePlane
			endif
		endif
		if (ls.asfolder)
			nname = "img_green" + nname
			rename img_green $nname
		endif
	endif
	
	// generate blue
	if (ls.blue)
		ImageTransform/P=2 getPlane img_source
		wave M_ImagePlane
		if (!ls.asstack)
			rename M_ImagePlane img_blue
			wave img_blue
		else
			if (!WaveExists(img_blue))
				rename M_ImagePlane img_blue
				wave img_blue
				redimension/N=(-1,-1,1) img_blue
			else
				nlayer = DimSize(img_blue,2)
				ImageTransform/INSW=M_ImagePlane/P=(nlayer)/O insertZplane img_blue
				killwaves/Z M_ImagePlane
			endif
		endif
		if (ls.asfolder)
			nname = "img_blue" + nname
			rename img_blue $nname
		endif
	endif
	
	// generate gray
	if (ls.gray)
		ImageTransform rgb2gray img_source
		wave M_RGB2Gray
		if (!ls.asstack)
			rename M_RGB2Gray img_gray
			wave img_gray
		else
			if (!WaveExists(img_gray))
				rename MRGB2Gray img_gray
				wave img_gray
				redimension/N=(-1,-1,1) img_gray
			else
				nlayer = DimSize(img_gray,2)
				ImageTransform/INSW=M_RGB2Gray/P=(nlayer)/O insertZplane img_gray
				killwaves/Z M_RGB2Gray
			endif
		endif
		if (ls.asfolder)
			nname = "img_gray" + nname
			rename img_gray $nname
		endif
	endif
	
	// single channel gray already
	if (ls.graw)
		if (bd != 0)
			if (bd > 3)
				// delete alpha channel
				Redimension/N=(-1,-1,3) img_source
			endif
			ImageTransform rgb2gray img_source
			wave M_RGB2Gray
			if (!ls.asstack)
				if (ls.asfolder)
					nname = "img_gray" + nname
					rename M_RGB2GRay $nname
				else
					rename M_RGB2Gray img_gray
				endif
			else
				if (!WaveExists(img_gray))
					rename M_RGB2Gray img_gray
				else
					nlayer = DimSize(img_gray,2)+1
					ImageTransform/D=M_RGB2Gray/CHIX=(nlayer) insertChunk img_gray
					killwaves/Z M_RGB2Gray
				endif	
			endif
		else
			if (!ls.asstack)
				duplicate/O img_source img_gray
			else
				if (!WaveExists(img_gray))
					duplicate img_source img_gray
					wave img_gray
					redimension/N=(-1,-1,1) img_gray
				else
					nlayer = DimSize(img_gray,2)
					ImageTransform/O/INSW=img_source/P=(nlayer) insertZPlane img_gray
				endif	
			endif
		endif
	endif
	
	// keep source?
	if (!ls.source)
		killwaves/Z img_source
	else
		if (ls.asfolder)
			nname = "img_rawsource" + nname
			rename img_source $nname
		else
			rename img_source img_rawsource
		endif
	endif
	
	return 0
end

Static Function/S create_ImgTDF(fname, ls, [stnum, digits])
	string fname
	STRUCT S_LoadSettings &ls
	variable stnum, digits
	
	string fs, basename, newname
	variable ic = 0, etrue = 1
	
	if (!ParamIsDefault(stnum))
		if (ParamIsDefault(digits))
			digits = 1
		endif
		fs =  "imgT_" + fname + "_%0" + num2str(digits) + "d"
		sprintf basename fs, (ls.startindex + stnum*ls.stepindex)
	else
		basename = "imgT_" + fname
	endif
	newname = basename
	
	// create folder
	SetDataFolder root:
	do
		if (DataFolderExists(newname))
			newname = basename + num2str(ic)
		else
			etrue = 0
		endif
	while(etrue)
	NewDataFolder $newname

	return newname
end

// load into an imgT data folder
// dfname - data folder name
// fname - file name with extension, ls - load settings
// stnum - stack index number, digits - sequence digits
// returns folder name
Static Function/S loadinto_imgTDF(dfname, fname, ls, xstore, [stindx])
	string dfname, fname
	STRUCT S_LoadSettings &ls
	variable xstore, stindx

	string rtnstr = ""
	string fldrstr
	
	// move to folder
	DFREF cdf = GetDataFolderDFR()
	DFREF imgDF = root:$dfname

	SetDataFolder imgDF

	// load and process the file
	if (ParamIsDefault(stindx))
		rtnstr = load_OneFile(fname, ls)
	else
		rtnstr = load_OneFile(fname, ls, stnum=stindx)
	endif
	if (!ls.loaderror)
		process_ImgSource(fname, ls)
		if (xstore == 0)
			if (ls.asfolder == 1)
				fldrstr = cleanup_ImageFileName(fname) + "_load"
				KillDataFolder/Z $fldrstr
				NewDataFolder/S $fldrstr
				store_LoadParams(fname,ls)	
				cleanup_Tags(fldrname = fldrstr)
				SetDataFolder ::
			else
				store_LoadParams(fname,ls)	
				cleanup_Tags()
			endif
		endif
	endif
	
	SetDataFolder cdf
	
	return rtnstr
end

// load one file in path imgPath
// fname - file name with extension
// ls - load settings; stnum - location number in stack
// creates img_source wave in current data folder
// returns string with success/fail statement
Static Function/S load_OneFile(fname, ls, [stnum])
	string fname
	STRUCT S_LoadSettings &ls
	variable stnum

	string fnsuffix
	string rtnstr = "\r-> Successfully loaded file " + fname
		
	// load the image file

	fnsuffix = ParseFilePath(4,fname,".",0,0)
	killwaves/Z img_source
	
	strswitch(fnsuffix)
		case "tif":
		case "tiff":
			if (ParamIsDefault(stnum))
				ImageLoad/RAT/P=imgPath/N=source/Q/Z fname
				if (v_flag == 0)
					ImageLoad/BIGT=1/LTMD/P=imgPath/N=source/Q/Z fname
					if (v_flag == 0)
						rtnstr = "\r-> ERROR IN FILE TYPE TIF - NO FILE LOADED for " + fname
						ls.loaderror = -1
					else
						ls.compressed = 1
					endif
				endif
			else
				if (stnum != inf)
					// load only a certain stack chunk
					ImageLoad/RAT/P=imgPath/S=(stnum)/N=source/C=1/Q/Z fname
					if (v_flag == 0)
						ImageLoad/BIGT=1/LTMD/P=imgPath/S=(stnum)/N=source/C=1/Q/Z fname
						if (v_flag == 0)
							rtnstr = "\r-> ERROR IN FILE TYPE TIF - NO FILE LOADED for " + fname
							ls.loaderror = -1
						else
							ls.compressed = 1
						endif
					endif
				else
					// load an entire stack
					ImageLoad/RAT/P=imgPath/N=source/C=(-1)/Q/Z fname
					if (v_flag == 0)
						ImageLoad/BIGT=1/LTMD/P=imgPath/N=source/Q/Z fname
						if (v_flag == 0)
							rtnstr = "\r-> ERROR IN FILE TYPE TIF - NO FILE LOADED for " + fname
							ls.loaderror = -1
						else
							ls.compressed = 1
						endif
					endif
				endif
			endif
			break
		case "jpg":
		case "jpeg":
			ImageLoad/T=jpeg/P=imgPath/N=source/Q/Z fname
			if (v_flag == 0)
				rtnstr = "\r-> ERROR IN FILE TYPE JPG - NO FILE LOADED for " + fname
				ls.loaderror = -1
			endif
			break
		case "png":
			ImageLoad/T=png/P=imgPath/N=source/Q/Z fname
			if (v_flag == 0)
				rtnstr = "\r-> ERROR IN FILE TYPE PNG - NO FILE LOADED for " + fname
				ls.loaderror = -1
			endif
			break
	endswitch

	if (ls.loaderror == 0)
		fname = StringFromList(0,S_wavenames)
		rename $fname img_source
		wave img_source
	endif
	
	return rtnstr
end

// store file load parameters
Static Function store_LoadParams(fname,ls)
	string fname
	STRUCT S_LoadSettings &ls
	
	NewDataFolder/O/S imgT_loadparams

	string/G sDateLoaded = f_DateTimeStamp()
	PathInfo imgPath
	string/G sFileName = s_path + fname
	variable/G imgred, imggreen, imgblue, imgsource, imggray, imgstack, imgcompressed
	imgred = ls.red
	imggreen = ls.green
	imgblue = ls.blue
	imggray = ls.gray
	imgsource = ls.source
	imgstack = ls.asstack
	imgcompressed = ls.compressed
	
	SetDataFolder ::
	return 0
end

// load list of files as a stack
// fname - folder name
// flist - file name list; ls - load settings
// stnum - start number, digits - sequence digits
// returns folder name
Static Function/S load_OneFileasStack(fname,flist,ls,[stnum,digits])
	string fname,flist
	STRUCT S_LoadSettings &ls
	variable stnum, digits

	string fnprefix, newFldrName, imgname, fs
	variable ic, nChunks, bd
	
	// create and move to folder
	DFREF cdf = GetDataFolderDFR()

	fnprefix = "imgT_" + CleanUpName(fname,0)
	if (!ParamIsDefault(stnum))
		fs =  fnprefix + "_%0" + num2str(digits) + "d_stack"
		sprintf fnprefix fs, ls.startindex
	endif
	//newFldrName = create_ImgTFolder(fnprefix)
	DFREF imgDF = root:$newFldrName

	SetDataFolder imgDF

	// load the first file and set the file to load images
	nChunks = ItemsInList(flist)
	fname = StringFromList(0,flist)	
	
	if (ls.compressed)
		ImageLoad/BIGT=1/LTMD/P=imgPath/Q/N=imgFile/Z fname
		if (v_flag == 0)
			SetDataFolder cdf
			KillDataFolder/Z imgDF
			return "ERROR IN FILE TYPE - NO FILE LOADED"
		endif
	else
		ImageLoad/RTIO/P=imgPath/Q/Z fname
		ImageLoad/P=imgPath/Q/N=imgrawsource/Z fname
		if (v_flag == 0)
			SetDataFolder cdf
			KillDataFolder/Z imgDF
			return "ERROR IN FILE TYPE - NO FILE LOADED"
		endif
	endif
	wave imgrawsource

	// load each file into a stack
	if (ls.graw)
		Redimension/N=(-1,-1,1) imgrawsource
		for(ic=1;ic<nChunks;ic+=1)
			fname = StringFromList(ic,flist)
			if (ls.compressed)
				ImageLoad/BIGT=1/LTMD/P=imgPath/Q/N=imgFile/Z fname
				if (v_flag == 0)
					SetDataFolder cdf
					KillDataFolder/Z imgDF
					return "ERROR IN FILE TYPE - NO FILE LOADED"
				endif
			else
				ImageLoad/RTIO/P=imgPath/Q/Z fname
				ImageLoad/P=imgPath/Q/N=imgFile/Z fname
				if (v_flag == 0)
					SetDataFolder cdf
					KillDataFolder/Z imgDF
					return "ERROR IN FILE TYPE - NO FILE LOADED"
				endif
			endif
			wave imgFile
			ImageTransform/O/INSW=imgFile/P=(ic) insertZplane imgrawsource
			killwaves/Z imgFile
		endfor	
		// make the source to tmp
		Duplicate/O imgrawsource imgtmp
		wave imgtmp
	else
		Redimension/N=(-1,-1,-1,1) imgrawsource
		for(ic=1;ic<nChunks;ic+=1)
			fname = StringFromList(ic,flist)
			if (ls.compressed)
				ImageLoad/BIGT=1/LTMD/P=imgPath/Q/N=imgFile/Z fname
				if (v_flag == 0)
					SetDataFolder cdf
					KillDataFolder/Z imgDF
					return "ERROR IN FILE TYPE - NO FILE LOADED"
				endif
			else
				ImageLoad/RTIO/P=imgPath/Q/Z fname
				ImageLoad/P=imgPath/Q/N=imgFile/Z fname
				if (v_flag == 0)
					SetDataFolder cdf
					KillDataFolder/Z imgDF
					return "ERROR IN FILE TYPE - NO FILE LOADED"
				endif
			endif
			wave imgFile
			ImageTransform/D=imgFile/CHIX=(ic) insertChunk imgrawsource
			killwaves/Z imgFile
		endfor	
		// make the source to tmp
		Duplicate/O imgrawsource imgtmp
		wave imgtmp
		Redimension/E=1/N=(-1,-1,3*nChunks) imgtmp
		nChunks = nChunks*3 - 1
	endif
			
	// convert to 8 bit if needed
	bd = f_ImageBitDepth(simgname = "imgtmp")
	if ((bd == 16) && !ls.allow16bit)
		Redimension/D imgtmp
		imgtmp /= 2^8
		Redimension/B/U imgtmp
	endif

	// get components
	if (ls.red)
		MatrixOP/O img_red = imgtmp[][][0,nChunks,3]
		wave img_red
	endif
	if (ls.green)
		MatrixOP/O img_green = imgtmp[][][1,nChunks,3]
		wave img_green
	endif
	if (ls.blue)
		MatrixOP/O img_blue = imgtmp[][][2,nChunks,3]
		wave img_blue
	endif
	if (ls.gray)
		ImageTransform rgb2gray imgrawsource
		wave M_RGB2Gray
		MatrixOP/O img_gray = M_RGB2gray[][][0,nChunks,3]		
	endif
	
	// single channel gray already
	if (ls.graw)
		duplicate/O imgtmp img_gray
		ls.gray = 1
	endif

	// keep source?
	if (!ls.source)
		killwaves/Z imgrawsource, imgtmp
	else
		killwaves/Z imgrawsource
		rename imgtmp imgrawsource
	endif
	
	// store the load parameters and clean up tags
	store_LoadParams(fname,ls)
	cleanup_Tags()
	
	SetDataFolder cdf
	return newFldrName
end

// load a stack as a stack
// dfname - datafolder name
// fname - file name; ls - load settings
// stnum - start number, digits - sequence digits
// returns folder name
Static Function/S load_StackasStack(dfname, fname, ls, [stnum, digits])
	string dfname, fname
	STRUCT S_LoadSettings &ls
	variable stnum, digits
	
	string rtnstr = ""
	variable no, ns, ng, nload, nlayers, isOneChannel = 0, bd
	
	// move to folder
	DFREF cdf = GetDataFolderDFR()
	DFREF imgDF = root:$dfname

	SetDataFolder imgDF

	// load
	no = ls.startimage - 1
	ns = ls.stepimage
	nload = (ls.endimage - 1)*ns
	
	rtnstr = load_OneFile(fname, ls, stnum=inf)
	if (ls.loaderror == -1)
		SetDataFolder cdf
		return ""
	endif
	wave/Z img_source, img_red, img_green, img_blue, img_gray
	
	nlayers = DimSize(img_source,3)
	if (nlayers == 0)
		isOneChannel = 1
		nlayers = DimSize(img_source,2)
		ls.red = 0
		ls.green = 0
		ls.blue = 0
		ls.gray = 0
		ls.graw = 1
	endif
	
#ifdef DEBUG
	print "Want to load and actual load: ", nload, nlayers
#endif

	// process
	if (ls.endimage == inf)
		nload = nlayers - 1
	endif
	if (nload > nlayers)
		nload = nlayers - 1
	endif
	rtnstr += " from start " + num2str(no) + " to end " + num2str(nload) + " by step " + num2str(ns)

	Duplicate/O img_source imgtmp
	if (!isOneChannel)
		// convert three channel to 3x layers
		Redimension/E=1/N=(-1,-1,3*nlayers) imgtmp
	endif
	
	wave imgtmp
			
	// convert to 8 bit if needed
	bd = f_ImageBitDepth(simgname = "imgtmp")
	if ((bd == 16) && !ls.allow16bit)
		Redimension/D imgtmp
		imgtmp /= 2^8
		Redimension/B/U imgtmp
	endif
	
	// get components
	if (!isOneChannel)
		if (ls.gray)
			ImageTransform rgb2gray img_source
			wave M_RGB2Gray
			MatrixOP/O img_gray = M_RGB2gray[][][no, nload, ns]		
		endif
		no *= 3
		ns *= 3
		nload = 3*nload
		if (ls.red)
			MatrixOP/O img_red = imgtmp[][][no, nload, ns]
		endif
		if (ls.green)
			ng = no + 1
			MatrixOP/O img_green = imgtmp[][][ng, nload, ns]
		endif
		if (ls.blue)
			ng = no + 2
			MatrixOP/O img_blue = imgtmp[][][ng, nload, ns]
		endif
	endif
	
	// single channel gray already
	if (ls.graw)
		MatrixOP/O img_gray = imgtmp[][][no, nlayers, ns]
		ls.gray = 1
	endif

	// keep source?
	if (!ls.source)
		killwaves/Z img_source, imgtmp
	else
		killwaves/Z img_source
		rename img_source img_rawsource
	endif
	
	// store the load parameters and clean up tags
	store_LoadParams(fname, ls)
	cleanup_Tags()

	SetDataFolder cdf
	return rtnstr
end

// clean up the file name
Static Function/S cleanup_ImageFileName(fn)
	string fn
	
	variable ne
	string rstr
	// remove file name prefix
	ne = ItemsInList(fn,".") - 1
	// remove file ending
	fn = RemoveListItem(ne,fn,".")
	// zap periods
	fn = ReplaceString(".",fn,"")
	// zap extra spaces
	rstr = ReplaceString("  ",fn," ")
	// make clean
	rstr = cleanupname(rstr,0)
	return rstr
end

// choose folders for conversion
Function T0_ConvertDataFolders([string dFolder])
	
	STRUCT S_LoadSettings ls
	variable asStack, nc = 0

	SetDataFolder root:
	
	if (ParamIsDefault(dFolder))
		CreateBrowser/M prompt="Choose root data folders to convert to formats readable by Image Tools"
		ModifyBrowser/M showwaves=0, showvars=0, showstrs=0, executeMode=2, showInfo=0, showPlot=0
		ModifyBrowser/M showModalBrowser
	
		if (v_flag == 1)
			Sf_GetLoadSettings(ls)
			nc = imgT_doConversion(S_BrowserList,ls.asStack)
		endif
	else
		Sf_GetLoadSettings(ls)
		nc = imgT_doConversion(dFolder,ls.asStack)
	endif
	return nc
end

// convert folders
Static Function imgT_doConversion(fldrList,asStack)
	string fldrList
	variable asStack
	
	variable ic, jc, nfldrs, nimgs, nTimgs, tas, bitdepth
	string theFldr, theImgList, theImg, theNName, strLoad
	
	nimgs = 0
	nfldrs = ItemsInList(fldrList)
	if (nfldrs == 0)
		return 0
	endif
	fldrList = ReplaceString("root:",fldrList,"")
	fldrList = ReplaceString(":",fldrList,"")
	fldrList = SortList(fldrList)
	for (ic=0;ic<nfldrs;ic+=1)
		theFldr = StringFromList(ic,fldrList)
		DuplicateDataFolder/O=1 $theFldr, imgT_tmp
		SetDataFolder imgT_tmp
		// convert 2-D images
		theImgList = SortList(WaveList("*",";","DIMS:2"))
		nimgs = ItemsInList(theImgList)
		if (nimgs < 4)
			tas = 0
		else
			tas = asStack
		endif
		for (jc=0;jc<nimgs;jc+=1)
			theImg = StringFromList(jc,theImgList)
			// tas = 1 means store as stack
			theNName = "img_"+CleanUpName(RemoveEnding(theImg,".JPG"),0)
			if (tas)
				if (jc==0)
					//theNName += "_st"
					Rename $theImg $theNName
					wave simg = $theNName
					redimension/N=(-1,-1,nimgs) simg
				else
					wave snimg = $theImg
					ImageTransform/O/D=snimg/P=(jc) setPlane simg
					killwaves/Z snimg
				endif
			else
				wave img = $theImg
				Rename $theImg $theNName
			endif
		endfor		
		nTimgs += nimgs
		// convert 3-D images
		theImgList = SortList(WaveList("*",";","DIMS:3"))
		nimgs = ItemsInList(theImgList)
		if (nimgs < 4)
			tas = 0
		else
			tas = asStack
		endif
		for (jc=0;jc<nimgs;jc+=1)
			theImg = StringFromList(jc,theImgList)
			// tas = 1 means store as stack
			theNName = "img_"+CleanUpName(RemoveEnding(theImg,".JPG"),0)
			if (tas)
				if (jc==0)
					//theNName += "_st"
					Rename $theImg $theNName
					wave simg = $theNName
					redimension/N=(-1,-1,nimgs) simg
				else
					wave snimg = $theImg
					ImageTransform/O/D=snimg/P=(jc) setPlane simg
					killwaves/Z snimg
				endif
			else
				// convert 3-layer image (JPEG) to single layer gray
				wave img = $theImg
				if (DimSize(img,2) == 3)
					ImageTransform/O/Q rgb2gray img
				endif
				Rename $theImg $theNName
			endif
		endfor
		nTimgs += nimgs
		killstrings/A/Z
		killvariables/A/Z
		SetDataFolder root:
		theNName = "imgT_" + CleanUpName(theFldr,0)
		RenameDataFolder imgT_tmp $theNName
	endfor
	
	sprintf strLoad, "%s -> Converted %d folders and %d images", f_DateTimeStamp(), nfldrs, nTimgs
	strLoad += "\r\tFolders: " + fldrList
	print strLoad
	
	if (nTimgs < 1)
		return -1
	else
		return nTimgs
	endif
end

// input file name list (unparsed) in path imgPath
// return 1 if valid, 0 if invalid
Static Function f_IsValidateforStack(string fList, variable sizecheck)

	variable nt, vRefNum, ic
	string tlist
	string theFile, fName
	
	// check number of files (stacks must be 4+ images)
	nt = ItemsInList(flist)	
	if (nt < 4)
		return 0
	endif
	
	// check file names (stacks only allowed from tiff)	
	tlist = ListMatch(fList,"*.png")
	tlist += ListMatch(fList,"*.jpg")
	tlist += ListMatch(fList,"*.jpeg")
	nt = ItemsInList(tlist,";")
	if (nt > 0)
		return 0
	endif
	
	// check file sizes (images must be same sizes)
	if (sizecheck)
		nt = ItemsInList(flist)	
		Make/D/N=(nt)/FREE File_Sizes = NaN
		for (ic=0;ic<nt;ic+=1)
			theFile = StringFromList(ic,fList)
			fName = ParseFilePath(0,theFile,":",1,0)
			Open/R/Z/P=imgPath vRefNum as fName
			if (v_flag==0)
			    FStatus vRefNum
			    File_Sizes[ic]=V_logEOF
			endif    
			Close vRefNum
		endfor		
		Close/A		
		FindDuplicates/FREE/RN=Unique_File_Sizes File_Sizes		
		if (numpnts(Unique_File_Sizes) != 1)
			return 0
		endif
	endif
	
	return 1
end